	function Cost = COST_DIFF_Z_fun(X, N)
	
	% 	Cost function for a differentiator
	% 	Used in PRAXIS in Example 9.22
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2010-10-21
	% 	Modified by:		 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1	
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	global p Des wT Nz Np
	
	[G, Z, P] = X_2_PZ(X);
	H = abs(PZ_2_FREQ_Z(G, Z, P, wT));
	Cost = sum((abs(H)-Des).^p);
	% Force a zero at z = 1
	Cost = Cost + (abs(H(1))-Des(1))*10000;
	return
	
